﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;

public partial class Admin_LunTan_BanZhu_ZengJia : System.Web.UI.Page
{
    private 访问 访问;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("增加版主", "网站后台", "增加版主", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            增加版主();
        else
            初始化();
    }

    private void 初始化()
    {
        DataSet 数据=new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[所属版块],[版块名称] FROM [" + 程序.数据表前缀 + "社区_论坛_版块]", 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "版块");

        生成列表(数据, 0, 1);
    }

    private void 生成列表(DataSet 数据, int 父版块, int 深度)
    {
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (Convert.ToInt32(行["所属版块"]) == 父版块)
            {
                ListItem 列表项 = new ListItem(生成空格(深度) + Convert.ToString(行["版块名称"]), Convert.ToString(行["ID"]));
                SuoShuBanKuai.Items.Add(列表项);
                生成列表(数据, Convert.ToInt32(行["ID"]), 深度 + 1);
            }
        }
    }

    private String 生成空格(int 数量)
    {
        String 返回值 = "";
        for (int i = 0; i < 数量; i++)
            返回值 += "　";
        return 返回值 + "|-";
    }

    private String 获取版块名称(int 版块ID)
    {
        String 返回值;
        SqlCommand 语句 = new SqlCommand("SELECT [版块名称] FROM [" + 程序.数据表前缀 + "社区_论坛_版块] WHERE [ID]=" + 版块ID, 访问.连接);
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            返回值 = Convert.ToString(读取["版块名称"]);
        else
        {
            读取.Close();
            throw new Exception("版块不存在");
        }
        读取.Close();
        return 返回值;
    }

    private String 获取版主昵称(int 版主ID)
    {
        String 返回值;
        SqlCommand 语句 = new SqlCommand("SELECT [昵称] FROM ["+程序.数据表前缀+"社区_用户_用户] WHERE [用户类型]='会员' AND [ID]=" + 版主ID, 访问.连接);
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            返回值 = Convert.ToString(读取["昵称"]);
        else
        {
            读取.Close();
            throw new Exception("用户不存在");
        }
        读取.Close();
        return 返回值;
    }

    private void 增加版主()
    {
        访问.验证权限("31");
        int 所属版块 = Convert.ToInt32(SuoShuBanKuai.SelectedValue);
        int 版主ID = Convert.ToInt32(BanZhuID.Text);
        String 版块名称 = 获取版块名称(所属版块);
        String 版主昵称 = 获取版主昵称(版主ID);

        int ZGID = 常用.SQL_最高ID(访问.连接, 程序.数据表前缀+"社区_论坛_版主");
        SqlCommand 语句 = new SqlCommand("INSERT INTO [" + 程序.数据表前缀 + "社区_论坛_版主]([ID],[所属版块],[版块名称],[版主ID],[版主昵称])" +
            "VALUES(@ID,@所属版块,@版块名称,@版主ID,@版主昵称)", 访问.连接);
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ZGID;
        语句.Parameters.Add("@所属版块", SqlDbType.Int).Value = 所属版块;
        语句.Parameters.Add("@版块名称", SqlDbType.NVarChar).Value = 版块名称;
        语句.Parameters.Add("@版主ID", SqlDbType.Int).Value = 版主ID;
        语句.Parameters.Add("@版主昵称", SqlDbType.NVarChar).Value = 版主昵称;
        语句.ExecuteNonQuery();

        new 消息(this.Context, 访问.连接).发送系统消息(版主ID, "恭喜您成为了版块[" + 版块名称 + "]的版主。");

        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("增加版主", 访问.用户["昵称"].ToString());

        Response.Redirect("BanZhu.aspx");
    }
}
